/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.search;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.search.SearchPredicates;
import appeng.menu.me.common.GridInventoryEntry;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;

public class RepoSearch {
    private String searchString = "";
    private final Long2BooleanMap cache = new Long2BooleanOpenHashMap();
    private Predicate<GridInventoryEntry> search = e -> true;
    private final Map<AEKey, String> tooltipCache = new WeakHashMap<AEKey, String>();

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        if (!searchString.equals(this.searchString)) {
            this.search = SearchPredicates.fromString(searchString, this);
            this.searchString = searchString;
            this.cache.clear();
        }
    }

    public boolean matches(GridInventoryEntry entry) {
        return this.cache.computeIfAbsent(entry.getSerial(), s -> this.search.test(entry));
    }

    public String getTooltipText(AEKey what) {
        return this.tooltipCache.computeIfAbsent(what, key -> AEStackRendering.getTooltip(key).stream().map(Component::getString).collect(Collectors.joining("\n")));
    }
}

